% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadModel.R
\name{loadModel}
\alias{loadModel}
\title{Load TensorFlow model from hdf5 file}
\usage{
loadModel(modelFile, restoreCustomObjects = TRUE)
}
\arguments{
\item{modelFile}{character. File name of the .hdf5 model file to load}

\item{restoreCustomObjects}{logical. Restore custom objects (loss function & dice coefficient) used in training of habitat models}
}
\value{
keras model
}
\description{
Load TensorFlow model from hdf5 file
}
\details{
Loads a trained TensorFlow model from a hdf5 file, and (optionally) restores custom objects.
}
\examples{
\dontrun{
# Canopy model
wd_model_can <- "C:/Path/To/Model"      # change this
filename_model_can <- "imageseg_canopy_model.hdf5"
model_can <- loadModel(file.path(wd_model_can, filename_model_can))

# Understory model
# note, here we just specify the complete path, not separate by directory and file name as above
model_file_us <- "C:/Path/To/Model/imageseg_understory_model.hdf5"
model_us <- loadModel(model_file_us)
}
}
