% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_sounding.R
\name{meteo_sounding}
\alias{meteo_sounding}
\title{Sounding data}
\source{
http://weather.uwyo.edu/upperair/sounding.html
}
\usage{
meteo_sounding(wmo_id, yy, mm, dd, hh)
}
\arguments{
\item{wmo_id}{international WMO station code (World Meteorological Organization ID); For Polish stations: Łeba - 12120, Legionowo - 12374, Wrocław- 12425}

\item{yy}{year - single number}

\item{mm}{month - single number denoting month}

\item{dd}{day - single number denoting day}

\item{hh}{hour - single number denoting initial hour of sounding; for most stations this measurement is done twice a day (i.e. at 12 and 00 UTC), sporadically 4 times a day}
}
\value{
Returns two lists with values described at: weather.uwyo.edu ; The first list contains:
\enumerate{
\item PRES - Pressure (hPa)
\item HGHT - Height (metres)
\item TEMP - Temperature (C)
\item DWPT - Dew point (C)
\item RELH - Relative humidity (%)
\item MIXR - Mixing ratio (g/kg)
\item DRCT - Wind direction (deg)
\item SKNT - Wind speed (knots)
\item THTA = (K)
\item THTE = (K)
\item THTV = (K)
}
The second list contains metadata and calculated thermodynamic / atmospheric instability indices
}
\description{
Downloading the mea (i.e., measurements of the vertical profile of atmosphere) sounding data
}
\examples{
\donttest{
  sounding <- meteo_sounding(wmo_id = 12120, yy = 2019, mm = 4, dd = 4, hh = 0)
  head(sounding)
  plot(sounding[[1]]$HGHT, sounding[[1]]$PRES, type = 'l')
}

}
