% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{repSave}
\alias{repSave}
\title{Save immune repertoires to the disk}
\usage{
repSave(.data, .path, .format = c("immunarch", "vdjtools"), .compress = TRUE)
}
\arguments{
\item{.data}{An R dataframe, a list of R dataframes or a list with \code{data} and
\code{meta} where first element is a list of dataframes and the latter is a dataframe
with metadata.}

\item{.path}{A string with the path to the output directory. It should include file
name if a single dataframe is provided to .data argument.}

\item{.format}{A string with desirable format specification. Current options are
"immunarch" and "vdjtools".}

\item{.compress}{A boolean value. Defines whether the output will be compressed or not.}
}
\value{
No return value.
}
\description{
The \code{repSave} function is deigned to save your data to the disk
in desirable format. Currently supports "immunarch" and "vdjtools" file formats.
}
\details{
It is not necessary to create directories beforehand. If the provided directory
does not exist it will be created automatically.
}
\examples{
data(immdata)
dirpath <- tempdir()
# Save the list of repertoires
repSave(immdata, dirpath)
# Load it and check if it is the same
new_immdata <- repLoad(dirpath)
# sum(immdata$data[[1]] != new_immdata$data[[1]], na.rm = TRUE)
# sum(immdata$data[[2]] != new_immdata$data[[2]], na.rm = TRUE)
# sum(immdata$meta != new_immdata$meta, na.rm = TRUE)
}
\concept{io}
