% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_public_repertoire}
\alias{vis.immunr_public_repertoire}
\title{Public repertoire visualisation}
\usage{
\method{vis}{immunr_public_repertoire}(.data, .plot = c("freq", "clonotypes"), ...)
}
\arguments{
\item{.data}{Public repertoire, an output from \link{pubRep}.}

\item{.plot}{A string specifying the plot type:

- "freq" for visualisation of the distribution of occurrences of clonotypes
and their frequencies using \link{vis_public_frequencies}.

- "clonotypes" for visualisation of public clonotype frequenciy correlations between pairs of
samples using \link{vis_public_clonotypes}}

\item{...}{Further arguments passed \link{vis_public_frequencies} or \link{vis_public_clonotypes},
depending on the ".plot" argument.}
}
\value{
A ggplot2 object.
}
\description{
Public repertoire visualisation
}
\examples{
data(immdata)
immdata$data <- lapply(immdata$data, head, 300)
pr <- pubRep(immdata$data, .verbose = FALSE)
vis(pr, "freq")
vis(pr, "freq", .type = "none")

vis(pr, "clonotypes", 1, 2)
}
\concept{pubrep}
