% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_outliers}
\alias{remove_outliers}
\title{Remove Outliers Based on Cluster Information}
\usage{
remove_outliers(dataset, settings)
}
\arguments{
\item{dataset}{A data frame that includes clustering results, particularly a \code{pandora_cluster} column.}

\item{settings}{A list of settings. Must contain the logical value \code{datasetAnalysisRemoveOutliersDownstream}.
If \code{datasetAnalysisRemoveOutliersDownstream} is TRUE, outliers (rows where \code{pandora_cluster == 100})
will be removed from the dataset.}
}
\value{
A filtered data frame with outliers removed if applicable.
}
\description{
The \code{remove_outliers} function removes rows from a dataset based on the presence
of outliers marked by a specific cluster ID (typically 100) in the \code{pandora_cluster} column.
This function is meant to be used internally during downstream dataset analysis
to filter out data points that have been identified as outliers during clustering.
}
\examples{
\dontrun{
# Example usage
dataset <- data.frame(pandora_cluster = c(1, 2, 100, 3, 100), values = 1:5)
settings <- list(datasetAnalysisRemoveOutliersDownstream = TRUE)
clean_data <- remove_outliers(dataset, settings)
print(clean_data)
}
}
\keyword{internal}
