% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations_agg.R
\name{agg_receptors}
\alias{agg_receptors}
\title{Aggregates AIRR data into receptors}
\usage{
agg_receptors(
  dataset,
  schema,
  barcode_col = NULL,
  count_col = NULL,
  locus_col = NULL,
  umi_col = NULL
)
}
\arguments{
\item{dataset}{A data frame or \code{duckplyr_df} containing sequence/clonotype data.
Must include columns specified in \code{schema} and potentially \code{barcode_col},
\code{count_col}, \code{locus_col}, \code{umi_col}. Could be \code{idata$annotations}.}

\item{schema}{Defines how a unique receptor is identified. Can be:
\itemize{
\item A character vector of column names representing receptor features
(e.g., \code{c("v_call", "j_call", "junction_aa")}).
\item A list created by \code{make_receptor_schema()}, specifying both \code{features}
(character vector) and optionally \code{chains} (character vector of locus
names like \code{"TRA"}, \code{"TRB"}, \code{"IGH"}, \code{"IGK"}, \code{"IGL"}, max length 2).
Specifying \code{chains} triggers filtering by locus and enables pairing logic
if two chains are given.
}}

\item{barcode_col}{Character(1). The name of the column containing cell
identifiers (barcodes). Required for single-cell processing and chain pairing.
Default: \code{NULL}.}

\item{count_col}{Character(1). The name of the column containing counts
(e.g., UMI counts for bulk, clonotype frequency). Used for bulk data
processing. Default: \code{NULL}. Cannot be specified if \code{barcode_col} is set.}

\item{locus_col}{Character(1). The name of the column specifying the chain locus
(e.g., "TRA", "TRB"). Required if \code{schema} includes \code{chains} for filtering
or pairing. Default: \code{NULL}.}

\item{umi_col}{Character(1). The name of the column containing UMI counts.
Required for \emph{paired-chain single-cell} data (\code{length(schema$chains) == 2}).
Used to select the most abundant chain per locus within a cell when multiple
chains of the same locus are present. Default: \code{NULL}.}
}
\value{
A \code{duckplyr_df} (or data frame) representing the annotated sequences.
This table links each original sequence record (chain) to a defined receptor
and includes standardized columns:
\itemize{
\item \code{imd_receptor_id}: Integer ID unique to each distinct receptor signature.
\item \code{imd_barcode_id}: Integer ID unique to each cell/barcode (or row if no barcode).
\item \code{imd_chain_id}: Integer ID unique to each input row (chain).
\item \code{imd_chain_count}: Integer count associated with the chain (1 for SC/simple,
from \code{count_col} for bulk).
This output is typically assigned to the \verb{$annotations} field of an \code{ImmunData} object.
}
}
\description{
Processes a table of immune receptor sequences (chains or clonotypes) to
identify unique receptors based on a specified schema. It assigns a unique
identifier (\code{imd_receptor_id}) to each distinct receptor signature and
returns an annotated table linking the original sequence data to these
receptor IDs.

This function is a core component used within \code{\link[=read_repertoires]{read_repertoires()}} and handles
different input data structures:
\itemize{
\item Simple tables (no counts, no cell IDs).
\item Bulk sequencing data (using a count column).
\item Single-cell data (using a barcode/cell ID column). For single-cell data,
it can perform chain pairing if the schema specifies multiple chains
(e.g., TRA and TRB).
}
}
\details{
The function performs the following main steps:
\enumerate{
\item \strong{Validation:} Checks inputs, schema validity, and existence of required columns.
\item \strong{Schema Parsing:} Determines receptor features and target chains from \code{schema}.
\item \strong{Locus Filtering:} If \code{schema$chains} is provided, filters the dataset
to include only rows matching the specified locus/loci.
\item \strong{Processing Logic (based on \code{barcode_col} and \code{count_col}):}
\itemize{
\item \strong{Simple Table/Bulk (No Barcodes):} Assigns unique internal barcode/chain IDs.
Identifies unique receptors based on \code{schema$features}. Calculates
\code{imd_chain_count} (1 for simple table, from \code{count_col} for bulk).
\item \strong{Single-Cell (Barcodes Provided):} Uses \code{barcode_col} for \code{imd_barcode_id}.
\itemize{
\item \strong{Single Chain:} (\code{length(schema$chains) <= 1}). Identifies unique
receptors based on \code{schema$features}. \code{imd_chain_count} is 1.
\item \strong{Paired Chain:} (\code{length(schema$chains) == 2}). Requires \code{locus_col}
and \code{umi_col}. Filters chains within each cell/locus group based
on max \code{umi_col}. Creates paired receptors by joining the two
specified loci for each cell based on \code{schema$features} from both.
Assigns a unique \code{imd_receptor_id} to each \emph{pair}.
\code{imd_chain_count} is 1 (representing the chain record).
}
}
\item \strong{Output:} Returns an annotated data frame containing original columns plus
internal identifiers (\code{imd_receptor_id}, \code{imd_barcode_id}, \code{imd_chain_id})
and counts (\code{imd_chain_count}).
}

Internal column names are typically managed by \code{immundata:::imd_schema()}.
}
\seealso{
\code{\link[=read_repertoires]{read_repertoires()}}, \code{\link[=make_receptor_schema]{make_receptor_schema()}}, \link{ImmunData}
}
\concept{aggregation}
