% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shm_event_reconstruction.R
\name{shm_event_reconstruction}
\alias{shm_event_reconstruction}
\title{Decodes immuneSIM repertoire shm_events column.}
\usage{
shm_event_reconstruction(shm_event_vec)
}
\arguments{
\item{shm_event_vec}{An vector containing strings describing SHM events as output in shm_events column of immuneSIM repertoires.
The string contains information on every mutation event in the form:

"Position:pre_mutation_nucleotide,post_mutation_nucleotide"
combined as: "Mutation1|Mutation2|Mutation3". For example: "171:t,a|186:g,a".}
}
\value{
List of dataframes. Each entry contains location and shm mutation info for a simulated sequence
}
\description{
Decodes immuneSIM repertoire shm_events column.
}
\examples{
shm_events_example<-c("171:t,a|186:g,a|287:g,a|310:t,c","","294:c,g|316:t,c|330:c,t")
shm_list<-shm_event_reconstruction(shm_events_example)
}
