% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_prefix_add.R
\name{HLA_prefix_add}
\alias{HLA_prefix_add}
\title{HLA_prefix_add}
\usage{
HLA_prefix_add(data, prefix = "HLA-")
}
\arguments{
\item{data}{A string with a single HLA allele.}

\item{prefix}{A character string to be added as a prefix to the column values.
Default is "HLA-".}
}
\value{
A data frame with the specified prefix added to the values in the
selected columns.
}
\description{
This function adds a specified prefix to the beginning of
each value in the identified columns of the given data frame. Useful for adding
HLA or gene prefixes.
}
\examples{
# The HLA_typing_LIS dataset contains a table as might be found in a clinical
# laboratory information system:
print(HLA_typing_LIS)

# The `HLA_prefix_add` function can be used to add the correct HLA prefixes to the table:
library(dplyr)
HLA_typing_LIS \%>\% mutate(
  across(
    mA1Cd.recipient:mA2Cd.recipient,
    ~ HLA_prefix_add(., "HLA-A*")
  )
)

}
