% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_funs.R
\name{get_regional_inputs_1997_to_present}
\alias{get_regional_inputs_1997_to_present}
\title{Return raw flu surveillance data for a specific WHO region}
\usage{
get_regional_inputs_1997_to_present(region, max_year)
}
\arguments{
\item{region}{name of WHO region. Run \code{show_available_regions()} for a list of options.}

\item{max_year}{results will be output for all available years up to \code{max_year}.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{WHOREGION}: name of WHO region.
\item \code{Year}: calendar year .
\item \code{n_H1N1}, \code{n_H2N2}, \code{n_H3N2}: number of influenza specimens that tested positive for each influenza A subtype.
\item \code{n_A}: total specimens positive for influenza A (= \code{n_H1N1} + \code{n_H2N2} + \code{n_H3N2}).
\item \code{n_BYam}, \code{n_BVic}: number of specimens positive for each lineage of influenza B: Victoria or Yamagata.
\item \code{n_B}: total specimens positive for influenza B.
\item \code{n_processed}: total specimens processed.
}
}
\description{
Load and return a tibble containing raw influenza surveillance data, aggregated across all countries in the WHO region of interest. Data are from \href{https://apps.who.int/flumart/Default?ReportNo=12}{WHO Flu Mart}.
}
\examples{
get_regional_inputs_1997_to_present("americas", 2017)

}
