% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.locf.R
\name{na.locf}
\alias{na.locf}
\title{Missing Value Imputation by Last Observation Carried Forward}
\usage{
na.locf(x, option = "locf", na.remaining = "rev")
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"locf" - for Last Observation Carried Forward}
   \item{"nocb" - for Next Obervation Carried Backward}
   }}

\item{na.remaining}{Method to be used for remaining NAs.
\itemize{
   \item{"keep" - to return the series with NAs}
   \item{"rm" - to remove remaining NAs}
   \item{"mean" - to replace remaining NAs by overall mean}
   \item{"rev" - to perform nocb / locf from the reverse direction}
   }}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Replaces each missing value with the most recent present value prior to it
 (Last Observation Carried Forward- LOCF). Optionally this can also be done starting from the back of the series
 (Next Observation Carried Backward - NOCB).
}
\details{
Replaces each missing value with the most recent present value prior to it
 (Last Observation Carried Forward- LOCF). This can also be done from the reverse direction -starting from the back
 (Next Observation Carried Backward - NOCB). Both options have the issue, that NAs at the beginning 
 (or for nocb at the end) of the time series can not be imputed (since there is no last value to 
 be carried forward present yet). In this case there are remaining NAs in the imputed time series.
 Since this only concerns very few values at the beginning of the series,
  na.remaining offers some quick solutions to get a series without NAs back.
}
\examples{
#Prerequisite: Create Time series with missing values
x <- ts(c(NA,3,4,5,6,NA,7,8))

#Example 1: Perform LOCF
na.locf(x)

#Example 2: Perform NOCF
na.locf(x, option = "nocb")

#Example 3: Perform LOCF and remove remaining NAs
na.locf(x, na.remaining = "rm")

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}

