% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.seasplit.R
\name{na.seasplit}
\alias{na.seasplit}
\title{Seasonally Splitted Missing Value Imputation}
\usage{
na.seasplit(x, algorithm = "interpolation", ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{algorithm}{Algorithm to be used after splits. Accepts the following input:
\itemize{
   \item{"interpolation" - Imputation by Interpolation}
   \item{"locf" - Imputation by Last Observation Carried Forward}
   \item{"mean" - Imputation by Mean Value}
   \item{"random" - Imputation by Random Sample}
   \item{"kalman" - Imputation by Kalman Smooting and State Space Models}
   \item{"ma" - Imputation by Weighted Moving Average}
   }}

\item{...}{Additional parameters for these algorithms that can be passed through. Look at \code{\link[imputeTS]{na.interpolation}}, \code{\link[imputeTS]{na.locf}},
\code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.mean}} for parameter options.}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Splits the times series into seasons and afterwards performs imputation
seperatly for each of the resulting time series datasets (each containing the data 
for one specific season).
}
\examples{
#Prerequisite: Load a time series with missing values
x <- tsAirgap

#Example 1: Perform seasonal splitted imputation using algortihm = "interpolation"
na.seasplit(x, algorithm = "interpolation")

#Example 2: Perform seasonal splitted imputation using algortihm = "mean"
na.seasplit(x, algorithm = "mean")

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}
}

