% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.incalogical.R
\name{is.incalogical}
\alias{is.incalogical}
\alias{incalogical2logical}
\title{Coerce to logical if value is logical according to INCA}
\usage{
is.incalogical(x)

incalogical2logical(x)
}
\arguments{
\item{x}{vector}
}
\value{
\code{is.incalogical} returns \code{TRUE} if the vector 
is logical according to INCA:s internal rules, \code{FALSE} otherwise.
\code{incalogical2logical} returns a logical vector if \code{x} 
can be coerced to such.
}
\description{
It is common that check boxes are blanks by default but that this should 
be interpreted as \code{TRUE}. There are however some uncommon cases
were the boxes are instead marked with "False" if \code{FALSE}, 
but otherwise left blank. 
We can therefore not be certain of a blank value and will therefore treat 
it as \code{NA}.
}
\details{
Note that logical vectors in INCA will behave differently when used 
internally in INCA. This is handled by the functions.
or w
}
\examples{
is.incalogical(c("", "", "True", ""))  # TRUE
is.incalogical(c("", "False", "", "")) # TRUE
is.incalogical(c("", "FALSE", "", "")) # FALSE
is.incalogical(logical(2)) # will be recognised as well
}
