% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regroup.R
\name{regroup}
\alias{regroup}
\title{Regroup 'incidence' objects}
\usage{
regroup(x, groups = NULL)
}
\arguments{
\item{x}{\verb{<incidence2>} object.}

\item{groups}{\verb{[character]}

The groups to sum over.

If \code{NULL} (default) then the function returns the corresponding object with
no groupings.}
}
\description{
This function regroups an \verb{<incidence2>} object across the specified groups.
The resulting \verb{<incidence2>} object will contains counts summed over the
groups present in the input.
}
\examples{
\dontshow{data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
\dontshow{withAutoprint(\{}
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    i <- incidence(
        dat,
        date_index = "date_of_onset",
        groups = c("gender", "hospital")
    )
    regroup(i)
    regroup(i, "hospital")
\dontshow{\})}
}

}
