% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{delay_model}
\alias{delay_model}
\title{Fit a delayed Exponential or Weibull model to one or two given sample(s).}
\usage{
delay_model(
  x = stop("Specify observations!", call. = FALSE),
  y = NULL,
  distribution = c("exponential", "weibull"),
  method = c("MPSE", "MLE0"),
  bind = NULL,
  ties = c("density", "equidist", "random", "error"),
  optim_args = NULL,
  verbose = 0
)
}
\arguments{
\item{x}{numeric. observations of 1st group. Can also be a list of data from two groups.}

\item{y}{numeric. observations from 2nd group}

\item{distribution}{character. Which delayed distribution is assumed? Exponential or Weibull.}

\item{method}{character. Which method to fit the model? 'MPSE' = maximum product of spacings estimation \emph{or} 'MLE0' = standard maximum likelihood estimation}

\item{bind}{character. parameter names that are bind together in 2-group situation.}

\item{ties}{character. How to handle ties.}

\item{optim_args}{list. optimization arguments to use. Use \code{NULL} to use the data-dependent default values.}

\item{verbose}{integer. level of verboseness. Default 0 is quiet.}
}
\value{
\code{incubate_fit} the delay-model fit object. Or \code{NULL} if optimization failed (e.g. too few observations).
}
\description{
Maximum product spacing is used to fit the parameters.
Numerical optimization is done by \code{stats::optim}.
}
