% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independence-package.R
\docType{package}
\name{independence}
\alias{independence}
\alias{_PACKAGE}
\alias{independence-test}
\alias{dependence-test}
\title{independence}
\description{
Fast Rank-Based Independence Testing
}
\details{
The package \code{independence} provides three ranking-based nonparametric tests
for the independence of two continuous variables X and Y:
\enumerate{
\item the classical Hoeffding's D test:
\code{\link{hoeffding.D.test}}
\item a refined variant of it, named R:
\code{\link{hoeffding.refined.test}}
\item the Bergsma-Dassios T* sign covariance:
\code{\link{tau.star.test}}
}
The first test is consistent assuming an absolutely continuous joint distribution,
i.e., the population coefficient D=0 iff the variables are independent.
The latter two are consistent under no restriction on the distribution.

Given an iid sample (X1,Y1),...,(Xn,Yn),
all three statistics are computed in time O(n log n)
improving upon previous implementations.
The statistics R and T* are computed by a new algorithm,
following work of Even-Zohar and Leng.
It is based on the fast counting of certain patterns
in the permutation that relates the ranks of X and Y.
See [arxiv:2010.09712] and references therein.
}
\examples{
library(independence)

## independent
set.seed(123)
xs = rnorm(10000)
ys = rnorm(10000)
hoeffding.D.test(xs,ys)
hoeffding.refined.test(xs,ys)
tau.star.test(xs,ys)

## dependent, even though uncorrelated
set.seed(123)
xs = rnorm(10000,0,3001:13000)
ys = rnorm(10000,0,3001:13000)
hoeffding.D.test(xs,ys)
hoeffding.refined.test(xs,ys)
tau.star.test(xs,ys)

## dependent but not absolutely continuous, fools Hoeffding's D
set.seed(123)
xs = runif(200)
f = function(x,y) ifelse(x>y, pmin(y,x/2), pmax(y,(x+1)/2))
ys = f(xs,runif(200))
hoeffding.D.test(xs,ys)
hoeffding.refined.test(xs,ys)
tau.star.test(xs,ys)

}
\seealso{
\code{\link{tau.star.test}},
\code{\link{hoeffding.D.test}},
\code{\link{hoeffding.refined.test}}
\code{\link{relative.order}}
}
\author{
Chaim Even-Zohar <\email{chaim@ucdavis.edu}>
}
