% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.calc.hoeffding}
\alias{.calc.hoeffding}
\title{Compute Hoeffding's D statistic}
\usage{
.calc.hoeffding(perm)
}
\arguments{
\item{perm}{An integer vector containing exactly 0,1,...,n-1 in any order.

    The validity of the input is not checked by this function.}
}
\value{
Hoeffding's D statistic of \code{perm}.

    The normalization is such that \emph{-1/60 <= D <= 1/30}.

    The return value -1.0 indicates an error.
}
\description{
This is an internal CPP function, used by the R function
\code{\link{hoeffding.D.test}}.
}
\details{
Given (X1,Y1),...,(Xn,Yn), Hoeffding's Dn only depends on the
permutation P that satisfies rank Yi = P[rank Xi].
This function computes Dn given P in O(n log n) time.
}
\examples{

.calc.hoeffding(0:4)
## [1] 0.03333333

.calc.hoeffding(c(0,3,2,1,4))
## [1] -0.01666667

set.seed(397)
.calc.hoeffding(order(runif(1000))-1) * 36
## [1] 0.004349087
}
