% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\docType{data}
\name{generate}
\alias{generate}
\alias{GENERATION_TYPES}
\title{Generate resamples, permutations, or simulations}
\format{An object of class \code{character} of length 3.}
\usage{
generate(x, reps = 1, type = NULL, ...)

GENERATION_TYPES
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{reps}{The number of resamples to generate.}

\item{type}{Currently either \code{bootstrap}, \code{permute}, or \code{simulate}.}

\item{...}{Currently ignored.}
}
\value{
A tibble containing \code{rep} generated datasets, indicated by the
\code{replicate} column.
}
\description{
Generation is done based on \code{\link[=specify]{specify()}} and (if needed) \code{\link[=hypothesize]{hypothesize()}}
inputs.
}
\examples{
# Permutation test for two binary variables
mtcars \%>\%
  dplyr::mutate(am = factor(am), vs = factor(vs)) \%>\%
  specify(am ~ vs, success = "1") \%>\%
  hypothesize(null = "independence") \%>\%
  generate(reps = 100, type = "permute")

}
\keyword{datasets}
