% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom-prob-test.R
\name{binom_calc}
\alias{binom_calc}
\alias{binom_test}
\title{Binomial Test}
\usage{
binom_calc(n, success, prob = 0.5, ...)

binom_test(data, prob = 0.5)
}
\arguments{
\item{n}{number of observations}

\item{success}{number of successes}

\item{prob}{assumed probability of success on a trial}

\item{...}{additional arguments passed to or from other methods}

\item{data}{binary/dichotomous factor}
}
\value{
\code{binom_test} returns an object of class \code{"binom_test"}.
An object of class \code{"binom_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{k}{number of successes}
\item{exp_k}{expected number of successes}
\item{obs_p}{assumed probability of success}
\item{exp_p}{expected probability of success}
\item{ik}{the largest number <= \code{exp_k} such that Pr(k = ik) <= Pr(k = kobs)}
\item{lower}{lower one sided p value}
\item{upper}{upper one sided p value}
\item{two_tail}{two sided p value}
}
\description{
Test whether the proportion of successes on a two-level
categorical dependent variable significantly differs from a hypothesized value.
}
\examples{
# using calculator
binom_calc(32, 13, prob = 0.5)

# using data set
binom_test(as.factor(hsb$female), prob = 0.5)
}
\references{
Hoel, P. G. 1984. Introduction to Mathematical Statistics.
5th ed. New York: Wiley.
}
\seealso{
\code{\link[stats]{binom.test}}
}

