# Influx OSS API Service
#
# No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
#
# The version of the OpenAPI document: 2.0.0
#
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Write operations
#' @description influxdbclient.Write
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ PostWrite } \emph{ Write time series data into InfluxDB }
#' 
#'
#' \itemize{
#' \item \emph{ @param } org character
#' \item \emph{ @param } bucket character
#' \item \emph{ @param } body character
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @param } content.encoding Enum < [gzip, identity] > 
#' \item \emph{ @param } content.type Enum < [text/plain, text/plain; charset&#x3D;utf-8, application/vnd.influx.arrow] > 
#' \item \emph{ @param } content.length integer
#' \item \emph{ @param } accept Enum < [application/json] > 
#' \item \emph{ @param } org.id character
#' \item \emph{ @param } precision \link{WritePrecision}
#'
#'
#' \item status code : 204 | Write data is correctly formatted and accepted for writing to the bucket.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Line protocol poorly formed and no points were written.  Response can be used to determine the first malformed line in the body line-protocol. All data in body was rejected and not written.
#'
#' \item return type : LineProtocolError 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 401 | Token does not have sufficient permissions to write to this organization and bucket or the organization and bucket do not exist.
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 403 | No token was sent and they are required.
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 413 | Write has been rejected because the payload is too large. Error message returns max size supported. All data in body was rejected and not written.
#'
#' \item return type : LineProtocolLengthError 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 429 | Token is temporarily over quota. The Retry-After header describes when to try the write again.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' Retry-After \tab A non-negative decimal integer indicating the seconds to delay after the response is received. \cr
#' }
#' \item status code : 503 | Server is temporarily unavailable to accept writes.  The Retry-After header describes when to try the write again.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' Retry-After \tab A non-negative decimal integer indicating the seconds to delay after the response is received. \cr
#' }
#' \item status code : 0 | Internal server error
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  PostWrite  ####################
#'
#' library(influxdbclient)
#' var.org <- 'org_example' # character | Specifies the destination organization for writes. Takes either the ID or Name interchangeably. If both `orgID` and `org` are specified, `org` takes precedence.
#' var.bucket <- 'bucket_example' # character | The destination bucket for writes.
#' var.body <- 'body_example' # character | Line protocol body
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#' var.content.encoding <- 'identity' # character | When present, its value indicates to the database that compression is applied to the line-protocol body.
#' var.content.type <- 'text/plain; charset=utf-8' # character | Content-Type is used to indicate the format of the data sent to the server.
#' var.content.length <- 56 # integer | Content-Length is an entity header is indicating the size of the entity-body, in bytes, sent to the database. If the length is greater than the database max body configuration option, a 413 response is sent.
#' var.accept <- 'application/json' # character | Specifies the return content format.
#' var.org.id <- 'org.id_example' # character | Specifies the ID of the destination organization for writes. If both `orgID` and `org` are specified, `org` takes precedence.
#' var.precision <- WritePrecision$new() # WritePrecision | The precision for the unix timestamps within the body line-protocol.
#'
#' #Write time series data into InfluxDB
#' api.instance <- WriteApi$new()
#'
#' result <- api.instance$PostWrite(var.org, var.bucket, var.body, zap.trace.span=var.zap.trace.span, content.encoding=var.content.encoding, content.type=var.content.type, content.length=var.content.length, accept=var.accept, org.id=var.org.id, precision=var.precision)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @export
WriteApi <- R6::R6Class(
  'WriteApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    PostWrite = function(org, bucket, body, zap.trace.span=NULL, content.encoding='identity', content.type='text/plain; charset=utf-8', content.length=NULL, accept='application/json', org.id=NULL, precision=NULL, ...){
      apiResponse <- self$PostWriteWithHttpInfo(org, bucket, body, zap.trace.span, content.encoding, content.type, content.length, accept, org.id, precision, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    PostWriteWithHttpInfo = function(org, bucket, body, zap.trace.span=NULL, content.encoding='identity', content.type='text/plain; charset=utf-8', content.length=NULL, accept='application/json', org.id=NULL, precision=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`org`)) {
        stop("Missing required parameter `org`.")
      }

      if (missing(`bucket`)) {
        stop("Missing required parameter `bucket`.")
      }

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      if (!is.null(`content.encoding`)) {
        headerParams['Content-Encoding'] <- `content.encoding`
      }

      if (!is.null(`content.type`)) {
        headerParams['Content-Type'] <- `content.type`
      }

      if (!is.null(`content.length`)) {
        headerParams['Content-Length'] <- `content.length`
      }

      if (!is.null(`accept`)) {
        headerParams['Accept'] <- `accept`
      }

      if (!is.null(org)) {
        queryParams['org'] <- org
      }

      if (!is.null(org.id)) {
        queryParams['orgID'] <- org.id
      }

      if (!is.null(bucket)) {
        queryParams['bucket'] <- bucket
      }

      if (!is.null(precision)) {
        queryParams['precision'] <- precision
      }

      if (!missing(`body`)) {
        contentType <- headerParams['Content-Type']
        if (is.na(contentType) || is.null(contentType) || startsWith(contentType, 'application/json')) {
          body <- `body`$toJSONString()
        }
      } else {
        body <- NULL
      }

      urlPath <- "/write"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    }
  )
)
