% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getInfra.R
\name{getInfra}
\alias{getInfra}
\title{An Infrastructure Proxy Function}
\usage{
getInfra(dataFrame = NULL, server = "google", zoom = 14)
}
\arguments{
\item{dataFrame}{The name of your data frame}

\item{server}{The map server you want to use.  Options are google, bing, and open.  Defaults to google}

\item{zoom}{The zoom level you want to use.  Defaults to 14.  Valid values for google are 0 to 22; values for bing are 1 to 19; values for open are 0 to 19}
}
\description{
This function takes latitude and longitude coordinates from a data frame
and downloads images from map servers for those coordinates.
It will return the file sizes of those map images which can
be used as a useful proxy for the level of infrastructure
development.  Map servers currently used are Google, Bing
and Openstreetmap.
}
\examples{
# In this example, we'll build a very low resolution (two degrees per grid cell) grid of Japan,
# retrieve the map values from Bing at zoom level 14, and render a simple map.

# First, define the latitude and longitude bounds of Japan and create a data frame.
# (This uses a very restricted version of the territory of Japan for the sake of speed.)

lats <- rep(rev(seq(32,44, by=2)), each=7)
lngs <- rep(seq(130,142, by=2), 7)

coords <- data.frame(lats,lngs)

infraBing <- getInfra(dataFrame = coords, zoom=14, server="bing")

# Now that we have the values in the newly-created infraBing
# variable we can plot them.  First, we need to define our colour
# gamut, running from 0 to the maximum map value retrieved.

grey <- gray(0:max(infraBing) / max(infraBing))

# Now we can plot.

png(filename="japanInfraBing.png", width=480, height=480, units="px")
plot(lngs, lats, col=grey[infraBing], pch=15, cex=14)
dev.off()
}
\keyword{bing}
\keyword{google}
\keyword{infrastructure}
\keyword{maps}
\keyword{openstreetmap}

