% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_aggregated_profiles.R
\name{print.aggregated_profiles_explainer}
\alias{print.aggregated_profiles_explainer}
\title{Prints Aggregated Profiles}
\usage{
\method{print}{aggregated_profiles_explainer}(x, ...)
}
\arguments{
\item{x}{an individual variable profile explainer produced with the \code{aggregate_profiles()} function}

\item{...}{other arguments that will be passed to \code{head()}}
}
\description{
Prints Aggregated Profiles
}
\examples{
library("DALEX")
titanic <- na.omit(titanic)

model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                         data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic[,-9],
                               y = titanic$survived == "yes")
selected_passangers <- select_sample(titanic, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_glm, selected_passangers)

head(cp_rf)

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic[,-9],
                              y = titanic$survived,
                              verbose = FALSE, precalculate = FALSE)

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)
}

}
