% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{injd}
\alias{injd}
\title{Example of an \code{injd} object}
\format{
The main data frame in \code{injd} gathers information of 28 players
and has 108 rows and 19 columns:
\describe{
\item{player}{Player identifier (factor)}
\item{t0}{Follow-up period of the corresponding player, i.e. player’s first observed date, same value for each player (Date)}
\item{tf}{Follow-up period of the corresponding player, i.e. player’s last observed date, same value for each player (Date)}
\item{date_injured}{Date of injury of the corresponding observation (if any). Otherwise NA (Date)}
\item{date_recovered}{Date of recovery of the corresponding observation (if any). Otherwise NA (Date)}
\item{tstart}{Beginning date of the corresponding interval in which the observation has been at risk of injury (Date)}
\item{tstop}{Ending date of the corresponding interval in which the observation has been at risk of injury (Date)}
\item{tstart_minPlay}{Beginning time. Minutes played in matches until the start of this interval in which the observation has been at risk of injury (numeric)}
\item{tstop_minPlay}{Ending time. Minutes played in matches until the finish of this interval in which the observation has been at risk of injury (numeric)}
\item{status}{injury (event) indicator (numeric)}
\item{enum}{an integer indicating the recurrence number, i.e. the \eqn{k}-th injury (event), at which the observation is at risk}
\item{days_lost}{Number of days lost due to injury (numeric)}
\item{player_id}{Identification number of the football player (factor)}
\item{season}{Season to which this player's entry corresponds (factor)}
\item{games_lost}{Number of matches lost due to injury (numeric)}
\item{injury}{Injury specification as it appears in \url{https://www.transfermarkt.com}, if any; otherwise NA (character)}
\item{injury_acl}{Whether it is Anterior Cruciate Ligament (ACL) injury or not (NO_ACL); if the interval corresponds to an injury, NA otherwise (factor)}
\item{injury_type}{A five level categorical variable indicating the type
of injury, whether Bone, Concussion, Ligament, Muscle or Unknown; if any,
NA otherwise (factor)}
\item{injury_severity}{A four level categorical variable indicating the
severity of the injury (if any), whether Minor (<7 days lost), Moderate ([7, 28)
days lost), Severe ([28, 84) days lost) or Very_severe (>=84 days lost);
NA otherwise (factor)}
}
}
\usage{
injd
}
\description{
An \code{injd} object (\strong{S3}), called \code{injd}, to showcase what
this object is like and also to save computation time in some help files
provided by the package. The result of applying \code{prepare_all()} to
\emph{raw_df_exposures} (\code{prepare_exp(raw_df_exposures, ...)}) and \cr
\emph{raw_df_injuries} (\code{prepare_inj(raw_df_injuries, ...)}).
}
\details{
It consists of a data frame plus 4 other attributes:
a character specifying the unit of exposure (\code{unit_exposure}); and 3
(auxiliary) data frames: \code{follow_up}, \code{data_exposures} and
\code{data_injuries}.
}
\keyword{datasets}
