% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{generate}
\alias{generate}
\title{Generate samples from fitted bru and inla models}
\usage{
generate(object, ...)
}
\arguments{
\item{object}{a fitted model.}

\item{...}{additional arguments affecting the samples produced.}
}
\value{
The form of the value returned by gg depends on the class of its argument. See the documentation of the particular methods for details of what is produced by that method.
}
\description{
Generic function for sampling for fitted models. The function invokes particular methods 
which depend on the class of the first argument.
}
\examples{
\donttest{
# Generate data for a simple linear model

input.df <- data.frame(x=cos(1:10))
input.df <- within(input.df, y <- 5 + 2*cos(1:10) + rnorm(10, mean=0, sd=0.1))

# Fit the model

fit <- bru(y ~ xeff(map = x, model = "linear"), "gaussian", input.df)
summary(fit)

# Generate samples for some predefined x

df = data.frame(x = seq(-4, 4, by = 0.1))
smp = generate(fit, df, ~ xeff + Intercept, n.samples = 10)

# Plot the resulting realizations

plot(df$x, smp[[1]], type = "l")
for (k in 2:length(smp)) points(df$x, smp[[k]], type = "l")

# We can also draw samples form the joint posterior

df = data.frame(x = 1)
smp = generate(fit, df, ~ data.frame(xeff, Intercept), n.samples = 10)
smp[[1]]

# ... and plot them

plot(do.call(rbind, smp))
}
}
\seealso{
Other sample generators: \code{\link{generate.bru}}
}
