% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.integration.R, R/deprecated.R,
%   R/integration.R, R/mappers.R, R/mesh.R
\name{ipoints}
\alias{ipoints}
\alias{cprod}
\alias{inlabru-deprecated}
\alias{integration_weight_aggregation}
\alias{mesh_triangle_integration}
\alias{bru_mapper.default}
\alias{bru_mapper_offset}
\alias{is.inside}
\alias{vertices.inla.mesh}
\alias{pixels}
\title{Deprecated functions in inlabru}
\usage{
ipoints(
  samplers = NULL,
  domain = NULL,
  name = NULL,
  group = NULL,
  int.args = NULL,
  project = deprecated()
)

cprod(..., na.rm = NULL, .blockwise = FALSE)

integration_weight_aggregation(mesh, integ)

mesh_triangle_integration(mesh, tri_subset = NULL, nsub = NULL)

\method{bru_mapper}{default}(...)

bru_mapper_offset(...)

is.inside(mesh, loc, mesh.coords = NULL)

vertices.inla.mesh(...)

pixels(mesh, nx = 150, ny = 150, mask = TRUE)
}
\arguments{
\item{samplers}{Description of the integration region boundary.
In 1D, a length 2 vector or two-column matrix where each row describes an interval,
or \code{NULL}
In 2D either a \code{SpatialPolygon} or a \code{SpatialLinesDataFrame} with a \code{weight} column
defining the width of the a transect line, and optionally further columns used by the
\code{group} argument, or \code{NULL}.  When \code{domain} is \code{NULL}, \code{samplers} may also
be an \code{inla.mesh.1d} or \code{inla.mesh} object, that is then treated as a \code{domain}
argument instead.}

\item{domain}{Either
\itemize{
\item when \code{samplers} is a 1D interval(s) definition only, \code{domain} can be
a single integer for the number of integration points to place in each 1D
interval, overriding \code{int.args[["nsub1"]]}, and otherwise
\item when \code{samplers} is \code{NULL}, \code{domain} can be a numeric vector of points,
each given integration weight 1 (and no additional points are added
in between),
\item an \code{inla.mesh.1d} object for continuous 1D integration, or
\item an \code{inla.mesh.2d} object for continuous 2D integration.
}}

\item{name}{Character array stating the name of the domains dimension(s).
If \code{NULL}, the names are taken from coordinate names from \code{samplers} for
\verb{Spatial*} objects, otherwise "x", "y", "z" for 2D regions and
\code{"x"} for 1D regions}

\item{group}{Column names of the \code{samplers} object (if applicable) for which
the integration points are calculated independently and not merged when
aggregating to mesh nodes.}

\item{int.args}{List of arguments passed to \code{bru_int_polygon}.
\itemize{
\item \code{method}: "stable" (to aggregate integration weights onto mesh nodes)
or "direct" (to construct a within triangle/segment integration scheme
without aggregating onto mesh nodes)
\item \code{nsub1}, \code{nsub2}: integers controlling the number of internal integration
points before aggregation. Points per triangle: \code{(nsub2+1)^2}.
Points per knot segment: \code{nsub1}
\item \code{poly_method}: if set to "legacy", selects an old polygon integration method
that doesn't handle holes. No longer supported, and will generate an error.
}}

\item{project}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in favour of \code{int.args(method=...)}.
If TRUE, aggregate the integration points to mesh vertices. Default:
\code{project = (identical(int.args$method, "stable"))}}

\item{\dots}{Usually passed on to other methods}

\item{na.rm}{logical; if \code{TRUE}, the rows with weight \code{NA} from the
non-overlapping full_join will be removed; if \code{FALSE}, set the undefined weights to \code{NA}.
If \code{NULL} (default), act as \code{TRUE}, but warn if any elements needed removing.}

\item{.blockwise}{logical; if \code{FALSE}, computes full tensor product integration.
If \code{TRUE}, computes within-block tensor product integration (used internally
by \code{\link[=fm_int]{fm_int()}}).
Default \code{FALSE}}

\item{mesh}{An \code{inla.mesh} object}

\item{integ}{\code{list} of \code{loc}, integration points,
and \code{weight}, integration weights,
or a \code{SpatialPointsDataFrame}. Only the coordinates and \code{weight} column
are handled.}

\item{tri_subset}{Optional triangle index vector for integration on a subset
of the mesh triangles (Default \code{NULL})}

\item{nsub}{number of subdivision points along each triangle edge, giving
\code{(nsub + 1)^2} proto-integration points used to compute
the vertex weights
(default \code{NULL=9}, giving 100 integration points for each triangle)}

\item{loc}{Points in space stored either as data.frame, a two-column matrix
of x and y coordinates or a SpatialPoints object.}

\item{mesh.coords}{Coordinate names of the mesh. Use only if loc is a
data.frame with respective column names.}

\item{nx}{Number of pixels in x direction}

\item{ny}{Number of pixels in y direction}

\item{mask}{If logical and TRUE, remove pixels that are outside the mesh.
If \code{mask} is a \code{Spatial} object, only return pixels covered by this object.}
}
\value{
\code{ipoints()}: A \code{data.frame}, \code{tibble}, \code{sf}, or \code{SpatialPointsDataFrame} of 1D and
2D integration points, including a \code{weight} column and \code{.block} column.

A \code{data.frame}, \code{sf}, or \code{SpatialPointsDataFrame} of multidimensional
integration points and their weights

\itemize{
\item \code{mesh_triangle_integration} returns a \code{list} with elements \code{loc}
and \code{weight} with integration points for the mesh
}

\code{is.inside()}: Single column matrix of Boolean values indicating if a point is
inside the mesh.

\code{SpatialPixelsDataFrame} covering the mesh
}
\description{
These functions still attempt to do their job, but will be removed in a
future version.
}
\section{Functions}{
\itemize{
\item \code{ipoints()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of \code{\link[fmesher:fm_int]{fmesher::fm_int()}}

\item \code{cprod()}: (Blockwise) cross product of integration points.

Calculates the groupwise cross product of integration points in different
dimensions and multiplies their weights accordingly.
If the object defining points in a particular dimension has no
weights attached to it all weights are assumed to be 1.

Legacy wrapper for \code{\link[=fm_cprod]{fm_cprod()}}

\item \code{integration_weight_aggregation()}: Aggregate integration weights onto mesh nodes

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{\link[fmesher:fm_vertex_projection]{fmesher::fm_vertex_projection()}} instead.

\item \code{mesh_triangle_integration()}: Integration scheme for mesh triangle interiors

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{\link[fmesher:fm_int_mesh_2d_core]{fmesher::fm_int_mesh_2d_core()}} instead.

\item \code{bru_mapper(default)}: Calls \code{bru_mapper_define}, passing all
arguments along. Mapper implementations should call \code{\link[=bru_mapper_define]{bru_mapper_define()}}
instead, and supply at least a \code{new_class} class name.
Use of the \code{bru_mapper.default} method was deprecated from version 2.7.0,
and removed in version 2.11.0

\item \code{bru_mapper_offset()}: Creates a \code{\link[=bru_mapper_const]{bru_mapper_const()}} mapper.

\item \code{is.inside()}: Find out which points are inside a mesh.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of \code{\link[=fm_is_within]{fm_is_within()}}.
Replace \code{is.inside(mesh, loc)} with \code{fm_is_within(loc, mesh)}.

\item \code{vertices.inla.mesh()}: Extract vertex locations from an \code{inla.mesh}.
Converts the vertices of an \code{inla.mesh} object into a \code{SpatialPointsDataFrame}.
Deprecated in favour of \code{\link[=fm_vertices]{fm_vertices()}}

\item \code{pixels()}: Generate \code{SpatialPixels} covering an \code{inla.mesh}.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of \code{\link[fmesher:fm_pixels]{fmesher::fm_pixels()}}

}}
\seealso{
\code{\link[=fm_cprod]{fm_cprod()}}

\code{\link[=fm_is_within]{fm_is_within()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\keyword{internal}
