% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{plot.bru}
\alias{plot.bru}
\title{Plot method for posterior marginals estimated by bru}
\usage{
\method{plot}{bru}(x, ...)
}
\arguments{
\item{x}{a fitted \code{\link[=bru]{bru()}} model.}

\item{...}{A character naming the effect to plot, e.g. "Intercept". For random
effects, adding \code{index = ...} plots the density for a single component of the
latent model.}
}
\value{
an object of class \code{gg}
}
\description{
\code{\link[=bru]{bru()}} uses \code{INLA::inla()} to fit models. The latter estimates the posterior densities of
all random effects in the model. This function serves to access and plot the posterior
densities in a convenient way.
}
\examples{

\dontrun{

# Generate some data and fit a simple model
input.df <- data.frame(x = cos(1:10))
input.df <- within(input.df, y <- 5 + 2 * cos(1:10) + rnorm(10, mean = 0, sd = 0.1))
fit <- bru(y ~ x, family = "gaussian", data = input.df)
summary(fit)

# Plot the posterior of the model's x-effect
plot(fit, "x")
}

}
