% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTolColors.R
\name{GetTolColors}
\alias{GetTolColors}
\title{Tol Color Palettes}
\usage{
GetTolColors(n, scheme = c("bright", "vibrant", "muted", "light", "rainbow"),
  alpha = NULL, plot = FALSE)
}
\arguments{
\item{n}{'integer'.
Number of colors to be in the palette, the maximum value is
dependent on the specified color scheme.}

\item{scheme}{'character'.
Color scheme: select \code{"bright"}, \code{"vibrant"},
\code{"muted"}, or \code{"light"} for qualitative colors; and
\code{"rainbow"} for sequential colors.
Where \code{n < 8} for \code{"bright"} and \code{"vibrant"},
\code{n < 10} for \code{"muted"} and \code{"light"}, and
\code{n < 24} for \code{"rainbow"}.}

\item{alpha}{'numeric'.
Alpha transparency, values range from 0 (fully transparent) to 1 (fully opaque).
Specify as \code{NULL} to exclude the alpha channel color component.}

\item{plot}{'logical'.
Whether to display the color palette.}
}
\value{
Returns a 'character' vector of length \code{n} with elements of 7 or 9 characters,
  \code{"#"} followed by the red, blue, green, and optionally alpha values in hexadecimal.
}
\description{
This function creates a vector of \code{n} colors from
qualitative and sequential color schemes by Paul Tol (2018).
}
\examples{
op <- par(mfrow = c(5, 1), oma = c(0, 0, 0, 0), mai = c(0.4, 0, 0.4, 0))
GetTolColors( 7, scheme = "bright",  plot = TRUE)
GetTolColors( 7, scheme = "vibrant", plot = TRUE)
GetTolColors( 9, scheme = "muted",   plot = TRUE)
GetTolColors( 9, scheme = "light",   plot = TRUE)
GetTolColors(23, scheme = "rainbow", plot = TRUE)
par(op)

GetTolColors(10, scheme = "rainbow", alpha = 0.5, plot = TRUE)

}
\references{
Tol, Paul, 2018, Colour Schemes:
  SRON Technical Note, doc. no. SRON/EPS/TN/09-002, issue 3.0, 17 p.,
  accessed July 18, 2018 at \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{color}
