% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetInsetLocation.R
\name{GetInsetLocation}
\alias{GetInsetLocation}
\title{Determine Location for Inset Graphics}
\usage{
GetInsetLocation(dx, dy, loc = "bottomright", inset = 0, pad = 0,
  padin = 0)
}
\arguments{
\item{dx, dy}{'numeric'.
Width and height of the inset graphics, respectively.}

\item{loc}{'character'.
Single keyword used to specify the position of the inset in the main plot region:
\code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"},
\code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"},
or \code{"center"} to denote inset location.}

\item{inset}{'numeric'.
Vector of length 2 giving the inset distance from the margins as a fraction of the main plot region.
Value is recycled as necessary.}

\item{pad}{'numeric'.
Vector of length 2 giving the padding distance from the margins in user coordinate units.
Value is recycled as necessary.}

\item{padin}{'numeric'.
Vector of length 2 giving the padding distance from the margins in inches.
Value is recycled as necessary.}
}
\value{
Returns a 'numeric' vector of length 2 giving the user coordinates
  for the bottom-left corner of the inset.
}
\description{
This function determines the location that may be used to
position an inset graphics in the main plot region.
}
\examples{
graphics::plot(NA, NA, xlim = c(0, 100), ylim = c(0, 1),
               xlab = "x", ylab = "y", xaxs = "i", yaxs = "i")
dx <- 20; dy <- 0.2
xy <- GetInsetLocation(dx, dy, loc = "bottomleft")
graphics::rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "red")
graphics::points(xy[1], xy[2], pch = 16, xpd = TRUE)
print(xy)

xy <- GetInsetLocation(dx, dy, loc = "bottomleft", inset = 0.05)
graphics::rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "pink")
graphics::points(xy[1], xy[2], pch = 16)
print(xy)

xy <- GetInsetLocation(dx, dy, loc = "topright", padin = 0.5)
graphics::rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "blue")

xy <- GetInsetLocation(dx, dy, loc = "left", pad = c(5, 0))
graphics::rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "green")

xy <- GetInsetLocation(dx, dy, loc = "center")
graphics::rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "brown")

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
