## ----"setup", include=FALSE---------------------------------------------------
library(inlpubs)
svg_orcid <- "<svg style='height:1em;position:relative;margin-left:.25em;vertical-align:middle;' viewBox='0 0 512 512' aria-describedby='orcid' role='img'><desc id='orcid'>ORCiD</desc><path fill='#A6CE39' d='M294.75 188.19h-45.92V342h47.47c67.62 0 83.12-51.34 83.12-76.91 0-41.64-26.54-76.9-84.67-76.9zM256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm-80.79 360.76h-29.84v-207.5h29.84zm-14.92-231.14a19.57 19.57 0 1 1 19.57-19.57 19.64 19.64 0 0 1-19.57 19.57zM300 369h-81V161.26h80.6c76.73 0 110.44 54.83 110.44 103.85C410 318.39 368.38 369 300 369z'></path></svg>"
svg_email <- "<svg style='height:1em;position:relative;margin-left:.25em;vertical-align:middle;' viewBox='0 0 512 512' aria-describedby='email' role='img'><desc id='email'>Email</desc><path fill='#4682B4' d='M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z'/></svg>"
cit <- inlpubs::pubs$citation
dt_opt <- list(
  "dom" = "Blfrtip",
  "lengthMenu" = list(
    c(10L, 25L, 50L, -1L),
    c("10", "25", "50", "all")
  ),
  "buttons" = list(
    list(
      "extend" = "copyHtml5",
      "titleAttr" = "Copy visible data (tab deliminated) to clipboard",
      "title" = NULL,
      "exportOptions" = list(
        "columns" =  ":visible",
        "rows" = ":visible"
      )
    ),
    list(
      "extend" = "csvHtml5",
      "titleAttr" = "Save all rows in a CSV (comma deliminated) file format",
      "filename" = "inlpubs-authors"
    )
  )
)

## ----"aut_dat", include=FALSE-------------------------------------------------
all_aut <- lapply(cit, function(x) names(x$author))
aut <- do.call("c", cit$author)
aut <- aut[!duplicated(aut)]
nm <- vapply(aut, function(x) format(x, c("family", "given")), character(1))
aut <- aut[order(nm)]
names(aut) <- NULL

key <- paste0(substr(format(aut, "given"), 1, 1), format(aut, "family"))
key <- vapply(key, function(x) strsplit(x, " ")[[1]][1], character(1))
key <- tolower(gsub("-", "", key))
key <- tolower(gsub("'", "", key))

author <- vapply(aut, function(x) {
  a <- format(x, c("family", "given"), braces = list(family = c("", ",")))
  orcid <- x$comment["ORCID"]
  if (!is.null(x$comment["ORCID"])) {
    href <- sprintf("https://orcid.org/%s", x$comment["ORCID"])
    icon <- sprintf("<a href='%s' target='_blank'>%s</a>", href, svg_orcid)
    a <- paste0(a, icon)
  }
  if (!is.null(x$email)) {
    href <- sprintf("mailto: %s", x$email)
    icon <- sprintf("<a href='%s'>%s</a>", href, svg_email)
    a <- paste0(a, icon)
  }
  a
}, character(1))

d <- data.frame(
  "author" = author,
  "total_pub" = NA_integer_,
  "single_aut" = NA_integer_,
  "multi_aut" = NA_integer_,
  "first_aut" = NA_integer_,
  "syear" = NA_integer_,
  "eyear" = NA_integer_,
  row.names = key, stringsAsFactors = FALSE
)
for (i in seq_along(key)) {
  d$total_pub[i] <- sum(vapply(all_aut, function(x) {
    key[i] %in% x
  }, logical(1)))
  d$single_aut[i] <- sum(vapply(all_aut, function(x) {
    length(x) == 1 & key[i] %in% x
  }, logical(1)))
  d$multi_aut[i] <- sum(vapply(all_aut, function(x) {
    length(x) > 1 & key[i] %in% x
  }, logical(1)))
  d$first_aut[i] <- sum(vapply(all_aut, function(x) {
    length(x) > 1 & key[i] == x[1]
  }, logical(1)))
  bib <- cit[vapply(all_aut, function(x) key[i] %in% x, logical(1))]
  yrs <- range(as.integer(vapply(bib, function(x) x$year, character(1))))
  d$syear[i] <- yrs[1]
  d$eyear[i] <- yrs[2]
}

d <- d[order(d$total_pub, decreasing = TRUE), ]

aut_dat <- d

## ----"aut_tbl", echo=FALSE, results="asis"------------------------------------
cols <- c(
  "Author name",
  "Total<br/>publications",
  "Single-<br/>authored",
  "Multi-<br/>authored",
  "First-<br/>authored",
  "First<br/>year",
  "Last<br/>year"
)
DT::datatable(aut_dat,
  options = dt_opt,
  extensions = "Buttons",
  class = "hover row-border compact",
  colnames = cols,
  rownames = FALSE,
  escape = FALSE,
  elementId = "htmlwidget-aut-tbl"
)

