% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innsight_plotly.R
\docType{class}
\name{innsight_plotly}
\alias{innsight_plotly}
\title{S4 class for plotly-based plots}
\description{
The S4 class \code{innsight_plotly} visualizes the results of the methods
provided from the package \code{innsight} using \href{https://plotly.com/r/}{plotly}.
In addition, it allows easier analysis of the results and modification of
the visualization by basic generic functions. The individual slots are for
internal use only and should not be modified.
}
\details{
This S4 class is a simple extension of a plotly object that enables
a more detailed analysis of the results and a way to visualize the results
of models with multiple input layers (e.g., images and tabular data).

The overall plot is created in the following order:
\enumerate{
\item The corresponding shapes and annotations of the slots \code{annotations}
and \code{shapes} are added to each plot in \code{plots}. This also adds the strips
at the top for the output node (or input layer) and, if necessary, on the
right side for the data point.
\item Subsequently, all individual plots are combined into one plot with
the help of the function \link[plotly:subplot]{plotly::subplot}.
\item Lastly, the global elements from the \code{layout} slot are added and if there
are multiple input layers (\code{multiplot = TRUE}), another output strip is
added for the columns.
}

An example structure of the plot with multiple input layers is shown below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{|      Output 1: Node 1      |      Output 1: Node 3      |
|   Input 1   |   Input 2    |   Input 1   |   Input 2    |
|---------------------------------------------------------|-------------
|             |              |             |              |
| plots[1,1]  |  plots[1,2]  | plots[1,3]  | plots[1,4]   | data point 1
|             |              |             |              |
|---------------------------------------------------------|-------------
|             |              |             |              |
| plots[2,1]  |  plots[2,2]  | plots[2,3]  | plots[2,4]   | data point 2
|             |              |             |              |
}\if{html}{\out{</div>}}

Additionally, some generic functions are implemented to visualize individual
aspects of the overall plot or to examine them in more detail. All available
generic functions are listed below:
\itemize{
\item \code{\link[=plot.innsight_plotly]{plot}},
\code{\link[=print.innsight_plotly]{print}} and
\code{\link[=show.innsight_plotly]{show}}
(all behave the same)
\item \code{\link[=[.innsight_plotly]{[}}
\item \code{\link[=[[.innsight_plotly]{[[}}
}
}
\section{Slots}{

\describe{
\item{\code{plots}}{The individual plotly objects arranged as a matrix (see
details for more information).}

\item{\code{shapes}}{A list of two lists with the names \code{shapes_strips} and
\code{shapes_other}. The list \code{shapes_strips} contains the shapes for the
strips and may not be manipulated. The other list \code{shapes_other} contains
a matrix of the same size as \code{plots} and each entry contains the shapes
of the corresponding plot.}

\item{\code{annotations}}{A list of two lists with the names \code{annotations_strips}
and \code{annotations_other}. The list \code{annotations_strips} contains the
annotations for the strips and may not be manipulated. The other list
\code{annotations_other} contains a matrix of the same size as \code{plots} and
each entry contains the annotations of the corresponding plot.}

\item{\code{multiplot}}{A logical value indicating whether there are multiple
input layers and therefore correspondingly individual ggplot2 objects
instead of one single object.}

\item{\code{layout}}{This list contains all global layout options, e.g. update
buttons, sliders, margins etc. (see \link[plotly:layout]{plotly::layout} for more details).}

\item{\code{col_dims}}{A list to assign a label to the columns for the output
strips.}
}}

