% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_freqWordCor.R
\name{getMostFreqWord}
\alias{getMostFreqWord}
\title{Returns most frequent words.}
\usage{
getMostFreqWord(wordF, numWords, getPlot = TRUE, mwidth = 1024,
  mheight = 800, formatType = "png")
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{numWords}{The number of words to be returned.}

\item{getPlot}{If \code{TRUE}, save a scatter plot in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}
}
\value{
The \code{numWords} most frequent words.
}
\description{
Returns most frequent words and plots their frequencies per document.
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), 
  excludeSW = FALSE)
file.remove(list.files(pattern = "loremIpsum"))
getMostFreqWord(wordF = wordOccuDF, numWords = 5)
}
