% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_message.R
\name{format_message}
\alias{format_message}
\title{Format messages and warnings}
\usage{
format_message(string, ..., line_length = options()$width)
}
\arguments{
\item{string}{A string.}

\item{...}{Further strings that will be concatenated as indented new lines.}

\item{line_length}{Numeric, the maximum length of a line.}
}
\value{
A formatted string.
}
\description{
Inserts line breaks into a longer message or warning string.
Line length is adjusted to maximum length of the console, if the width
can be accessed. By default, new lines are indented by two whitespace.
}
\examples{
msg <- format_message("Much too long string for just one line, I guess!",
  line_length = 15
)
message(msg)

msg <- format_message("Much too long string for just one line, I guess!",
  "First new line",
  "Second new line",
  "(both indented)",
  line_length = 30
)
message(msg)
}
