% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_model.R
\name{null_model}
\alias{null_model}
\title{Compute intercept-only model for mixed models}
\usage{
null_model(model, verbose = TRUE)
}
\arguments{
\item{model}{A mixed effects model.}

\item{verbose}{Toggle off warnings.}
}
\value{
The null-model of \code{x}
}
\description{
This function compute the null-model (i.e. \code{(y ~ 1)}) for the
  fixed effects part) of a random-intercept model.
}
\examples{
if (require("lme4")) {
  data(sleepstudy)
  m <- lmer(Reaction ~ Days + (1 + Days | Subject), data = sleepstudy)
  summary(m)
  summary(null_model(m))
}
}
