% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.inno.R
\name{install.inno}
\alias{install.inno}
\title{Downloads and installs Inno Setup}
\usage{
install.inno(quick_start_pack = FALSE, encryption_module = TRUE, ...)
}
\arguments{
\item{quick_start_pack}{logical (default is FALSE) - The Inno Setup QuickStart Pack includes Inno Setup and Inno Script Studio script editor. See \href{https://jrsoftware.org/is3rdparty.php}{Third-Party Files} page for more information.}

\item{encryption_module}{logical (default is TRUE) - Inno Setup's Encryption Module}

\item{...}{extra parameters to pass to \link{install.URL}}
}
\value{
TRUE/FALSE - was the installation successful or not.
}
\description{
Downloads and installs Inno Setup's \href{https://jrsoftware.org/isdl.php#stable}{stable release}
}
\details{
Inno Setup is a free installer for Windows programs. First introduced in 1997, it currently rivals many commercial installers in feature set and stability.

See \href{https://jrsoftware.org/isinfo.php#features}{Features} for more information.
}
\examples{

\dontrun{
install.inno()
install.inno(quick_start_pack = TRUE)
}

}
\author{
Tal Galili and Jonathan M. Hill
}
