% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_factors.R
\name{rating_factors}
\alias{rating_factors}
\title{Include reference group in regression output}
\usage{
rating_factors(model, colname = "estimate", exponentiate = TRUE)
}
\arguments{
\item{model}{a (generalized) linear model fit}

\item{colname}{name of column with estimates. Defaults to "estimate".}

\item{exponentiate}{Logical indicating whether or not to exponentiate the the coefficient estimates. Defaults to TRUE.}
}
\value{
data.frame
}
\description{
This extracts coefficients in terms of the original levels of the coefficients rather than the coded variables.
}
\details{
This function is adopted from the dummy.coef{stats} function. Our adoption prints a data.frame as output. Categorical variables
    should be changed to factors in the data.frame used to fit the (generalized) linear model.
}
\examples{
g1 <- glm(nclaims ~ age_policyholder, family = "poisson", data = MTPL)
rating_factors(g1)
}
\author{
Martin Haringa
}
