% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidalgo_Aux.R
\name{auxHidalgo}
\alias{auxHidalgo}
\alias{posterior_means}
\alias{initial_values}
\alias{posterior_medians}
\alias{credible_intervals}
\title{Auxiliary functions for the \code{Hidalgo} model}
\usage{
posterior_means(x)

initial_values(x)

posterior_medians(x)

credible_intervals(x, alpha = 0.95)
}
\arguments{
\item{x}{object of class \code{Hidalgo}, the output of the
\code{Hidalgo()} function.}

\item{alpha}{posterior probability contained in the computed credible
interval.}
}
\value{
\code{posterior_mean} returns the observation-specific \code{id} posterior means estimated with \code{Hidalgo}.

\code{initial_values} returns a list with the parameter specification
passed to the model.

\code{posterior_median} returns the observation-specific \code{id} posterior medians estimated with  \code{Hidalgo}.

\code{credible_interval} returns the observation-specific credible intervals for a specific
probability \code{alpha}.
}
\description{
Collection of functions used to extract meaningful information from the object returned
by the function \code{Hidalgo}
}
