% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosBubble}
\alias{CircosBubble}
\title{Create a BUBBLE module to a moduleList}
\usage{
CircosBubble(
  modulename,
  compareGroup = 1,
  maxRadius = 200,
  minRadius = 50,
  blockStroke = TRUE,
  blockStrokeColor = "black",
  blockStrokeWidth = 1,
  blockFill = FALSE,
  blockFillColor = "white",
  bubbleMaxSize = 5,
  bubbleMinSize = 2,
  minColor = "red",
  maxColor = "green",
  ValueAxisManualScale = FALSE,
  ValueAxisMaxScale = 10,
  ValueAxisMinScale = 0,
  totalLayer = 1,
  animationDisplay = FALSE,
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{compareGroup}{The group number of this module in compare module}

\item{maxRadius, minRadius}{Where the module should begin and end.}

\item{blockStroke}{Whether display the stroke between each bubble block}

\item{blockStrokeColor}{Stroke color for block}

\item{blockStrokeWidth}{Stroke width for block}

\item{blockFill}{Whether fill a block or not}

\item{blockFillColor}{The color for filling the block}

\item{bubbleMaxSize}{The max size for bubble}

\item{bubbleMinSize}{The min size for bubble}

\item{minColor}{The color the bubble with min value}

\item{maxColor}{The color the bubble with max value}

\item{ValueAxisManualScale}{Whether manually control the scale of value}

\item{ValueAxisMaxScale, ValueAxisMinScale}{The max and min scale value for manually control}

\item{totalLayer}{The color and width for stroke}

\item{animationDisplay}{Whether display animation}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of value in bubble plot with details including chr, start, end, value, name, layer, color and html.
Details can be found on document.}

\item{...}{Ignored}
}
\value{
The module tracks for bubble modules.
}
\description{
A bubble plot displayed in the visualization
}
\examples{
bubbleData<-bubbleExample
Circos(CircosBubble('Bubble01', maxRadius = 230, minRadius = 170, data=bubbleData, 
blockStroke = TRUE, bubbleMaxSize =10, bubbleMinSize = 2, maxColor = "red", minColor = "yellow",
totalLayer =3, animationDisplay = TRUE, animationType="linear"),
genome = list("2L"=23011544,"2R"=21146708,"3L"=24543557,"3R"= 27905053,"X"=22422827,"4"=1351857),
BUBBLEMouseOverDisplay =TRUE,innerRadius = 236)

}
