% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inter_frailty_cl.R
\name{inter_frailty_cl}
\alias{inter_frailty_cl}
\title{Cure rate frailty model for interval censored clustered data}
\usage{
inter_frailty_cl(dataset, left, right, delta, cov_theta, cov_beta, grp, M,
  b = 0.001, tol = 0.001, max_n = 100, par_cl = NULL, burn_in = 50,
  output_files = FALSE)
}
\arguments{
\item{dataset}{Dataset used to fit the model.}

\item{left}{Vector containing the last check times before event.}

\item{right}{Vector containing the first check times after event.}

\item{delta}{Flag vector indicating failure inside interval.}

\item{cov_theta}{String vector containing the column names to be used on the
cure rate predictor.}

\item{cov_beta}{String vector containing the column names to be used on the
predictor associated with the hazard function.}

\item{grp}{Vector containing cluster identifier (numeric or string).}

\item{M}{Number of replicates generated by each iteration on the ANDA
(Asymptotic Normal Data Augmentation) algorithm.}

\item{b}{Parameter for initial theta and beta variances.}

\item{tol}{Numeric for tolerance of convergence.}

\item{max_n}{Maximum number of algorithm's iterations without the burn in.}

\item{par_cl}{Registered SOCK cluster for parallel process. If NULL (default)
the program loops are executed sequentially.}

\item{burn_in}{Number of burn in iterations.}

\item{output_files}{Boolean indicating if text outputs for the estimates and
variances should be generated.}
}
\value{
The \code{inter_frailty_cl} function returns an list containing the
  following outputs: \item{\code{par}}{estimates of theta and beta
  parameters.} \item{\code{mcov}}{estimates for the covariance matrix of
  theta and beta parameters.} \item{\code{stop_c}}{stop criteria indicator
  assuming 1 when process is stopped for a non-convergence criteria. Assumes
  0 when convergence is reached.}
}
\description{
\code{inter_frailty_cl} returns a list with the estimated parameters
\code{par} and their covariance matrix \code{mcov}. The list also contains a
dummy variable \code{stop_c} assuming 0 if algorithm converged and 1 if a
stop criteria ended the process.
}
\examples{
set.seed(3)
sample_set <- sim_frailty_cl(80, nclus = 3)

## few iterations just to check how to use the function

inter_frailty_cl(sample_set, sample_set$L, sample_set$R, sample_set$delta,
c("xi1"), c("xi1"), grp = sample_set$clus, M = 20,
max_n = 2, burn_in = 0)

## precise estimate (computationally intensive)
\dontrun{

inter_frailty_cl(sample_set, sample_set$L, sample_set$R, sample_set$delta,
c("xi1", "xi2"), c("xi1", "xi2"), grp = sample_set$clus, M = 20,
max_n = 30, burn_in = 10)
}
}

