# Match the Biobase combine argument list. Note that my own code would be much
# cleaner without the unnecessary y argument, but we have to have it to match
# Biobase.

setGeneric( "combine", function( x, y, ... ) standardGeneric( "combine" ) )

setMethod(
          "combine",
          signature( "Intervals" ),
          function( x, y, ... ) {
            args <- c( if ( missing(y) ) list() else list(y), list(...) )
            if ( length( args ) > 0 ) {
              if ( any( sapply( args, is.null ) ) )
                args <- args[ !sapply( args, is.null ) ]
              if ( !all( sapply( args, type ) == type(x) ) )
                stop( "All arguments should have the same 'type' slot." )
              same_class <- all( sapply( args, is, "Intervals" ) )
              same_closed <- all( sapply( args, function(y) identical( closed(x), closed(y) ) ) )
              if ( !same_class || ( type(x) == "R" & !same_closed ) ) {
                warning( "Coercion to 'Intervals_full' required.", call. = FALSE )
                args <- lapply( args, as, "Intervals_full" )
                return( do.call( combine, c( list( as( x, "Intervals_full" ) ), args ) ) )
              }
              if ( type(x) == "Z" & !same_closed )
                args <- lapply(
                               args,
                               adjust_closure,
                               close_left = closed(x)[1],
                               close_right = closed(x)[2]
                               )              
              x@.Data <- do.call( rbind, c( list(x), args ) )
            }
            return(x)
          }
          )

setMethod(
          "combine",
          signature( "Intervals_full" ),
          function( x, y, ... ) {
            # TO-DO: coerce Intervals objects up if required.
            args <- c( if ( missing(y) ) list() else list(y), list(...) )
            if ( length( args ) > 0 ) {
              if ( any( sapply( args, is.null ) ) )
                args <- args[ !sapply( args, is.null ) ]
              if ( !all( sapply( args, type ) == type(x) ) )
                stop( "All arguments should have the same 'type' slot." )
              if ( !all( sapply( args, is, "Intervals_full" ) ) )
                args <- lapply( args, as, "Intervals_full" )
              x@.Data <- do.call( rbind, c( list(x), args ) )
              closed(x) <- do.call(
                                   rbind,
                                   c(
                                     list( closed(x) ),
                                     lapply( args, closed )
                                     )
                                   )
            }
            return(x)
          }
          )

setMethod(
          "combine",
          signature( "missing" ),
          function( x, y, ... ) {
            # Permitting do.call use with named lists, since do.call will put
            # elements whose names are not "x" or "y" into the ... argument.            
            args <- c( if ( missing(y) ) list() else list(y), list(...) )
            names( args ) <- NULL
            if ( length( args ) == 0 ) return ( NULL )
            else return( do.call( combine, args ) )
          }
          )
