% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tarpuy_varlist.R
\name{tarpuy_varlist}
\alias{tarpuy_varlist}
\title{Fieldbook variable list}
\usage{
tarpuy_varlist(fieldbook, varlist = NULL)
}
\arguments{
\item{fieldbook}{Data frame with the fieldbook.}

\item{varlist}{Data frame with the variables information. See examples.}
}
\value{
data frame
}
\description{
Function to include the variables to evaluate in the fieldbook design.
}
\details{
The function allows to include the arguments in the sheet that have
  the information of the variables. You should include 3 columns in the
  sheet: \code{{abbreviation}}, \code{{evaluation}} and \code{{sampling}}.
  See examples. The information will be extracted automatically and deploy
  the list of variable for the fieldbook design.
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "183upHd4wriZz2UnInoo5Ate5YFdk7cZlhE0sMQ2x5iw/edit#gid=532773890")
# browseURL(url)

info <- gsheet2tbl(url) 

fieldbook <- tarpuy_design(data = info)

url_var <- paste0("https://docs.google.com/spreadsheets/d/"
       , "183upHd4wriZz2UnInoo5Ate5YFdk7cZlhE0sMQ2x5iw/edit#gid=1335288687")
       
varlist <- gsheet2tbl(url_var) 

tarpuy_varlist(fieldbook = fieldbook, varlist = varlist)

}

}
