% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_ifrp.R
\name{AdaptiveIFRP}
\alias{AdaptiveIFRP}
\title{Compute adaptive intrinsic factor risk premia}
\usage{
AdaptiveIFRP(
  returns,
  factors,
  penalty_parameters,
  weights = rep(1, ncol(factors)),
  relaxed = FALSE,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{\verb{n_observations x n_returns}-dimensional matrix of test asset
excess returns.}

\item{factors}{\verb{n_observations x n_factors}-dimensional matrix of factors.}

\item{penalty_parameters}{\code{n_parameters}-dimensional vector of penalty
parameter values from smallest to largest.}

\item{weights}{\code{n_factors}-dimensional vector of weights determining a
separate penalty parameter for each risk premium, given by vector
\code{penalty_parameter * weights}.
Default is a vector of ones, i.e., the same penalty parameter
\code{penalty_parameter} is applied to each risk premium.}

\item{relaxed}{boolean \code{TRUE} for re-fitting the model without shrinkage
post selection; \code{FALSE} otherwise. Default is \code{FALSE}.}

\item{check_arguments}{boolean \code{TRUE} if you want to check function arguments;
\code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
\verb{n_factors x n_parameters}-dimensional matrix of adaptive
intrinsic factor risk premia.
}
\description{
Computes adaptive intrinsic factor risk premia with user-defined
weights for various penalty parameter values.
}
\examples{
# import package data on 15 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

weights = 1. / rowSums(stats::cor(factors, returns))
penalty_parameters = seq(0., 1., length.out = 100)

# compute adaptive intrinsic factor risk premia for each penalty parameter
aifrp = AdaptiveIFRP(
returns,
factors,
penalty_parameters,
weights
)

}
