% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misspecification_distance.R
\name{HJMisspecificationDistance}
\alias{HJMisspecificationDistance}
\title{Compute the HJ asset pricing model misspecification distance.}
\usage{
HJMisspecificationDistance(
  returns,
  factors,
  ci_coverage = 0.95,
  hac_prewhite = FALSE,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{A \verb{n_observations x n_returns} matrix of test asset excess returns.}

\item{factors}{A \verb{n_observations x n_factors} matrix of risk factors.}

\item{ci_coverage}{A number indicating the confidence interval coverage
probability. Default is \code{0.95}.}

\item{hac_prewhite}{A boolean indicating if the series needs pre-whitening by
fitting an AR(1) in the internal heteroskedasticity and autocorrelation
robust covariance (HAC) estimation. Default is \code{false}.}

\item{check_arguments}{A boolean: \code{TRUE} for internal check of all function
arguments; \code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
@return A list containing the squared misspecification-robust HJ
distance in \code{squared_distance}, and the lower and upper confidence bounds
in \code{lower_bound} and \code{upper_bound}, respectively.
}
\description{
Computes the Kan-Robotti (2008) <10.1016/j.jempfin.2008.03.003>
squared model misspecification distance:
\verb{square_distance = min_\{d\} (E[R] - Cov[R,F] * d)' * V[R]^\{-1\} * (E[R] - Cov[R,F] * d)},
where \code{R} denotes test asset excess returns and \code{F} risk factors,
and computes the associated confidence interval.
This model misspecification distance is a modification of the prominent
Hansen-Jagannathan (1997) \url{doi:10.1111/j.1540-6261.1997.tb04813.x}
distance, adapted to the use of excess returns for the test asset, and a
SDF that is a linear function of demeaned factors.
Clearly, computation of the confidence interval is obtained by means of an
asymptotic analysis under potentially misspecified models, i.e.,
without assuming correct model specification.
Details can be found in Kan-Robotti (2008) <10.1016/j.jempfin.2008.03.003>.
}
\examples{
# Import package data on 6 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

# Compute the HJ model misspecification distance
hj_test = HJMisspecificationDistance(returns, factors)

}
