% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elbow.R
\name{get_elbow}
\alias{get_elbow}
\title{Get an elbow point}
\usage{
get_elbow(x, y, ...)
}
\arguments{
\item{x}{The `x` values from the data where an elbow point is to be found.}

\item{y}{The `y` values from the data where an elbow point is to be found.}

\item{...}{Optional: additional arguments that will be passed to
[stats::approx()] if it is used.}
}
\value{
A list with two named numeric scalar elements, `x` and `y`. `x`
  contains the `x` value at the elbow point. `y` contains the `y` value at
  the elbow point. The elbow point is *not* necessarily one of the input data
  points; it may be interpolated.
}
\description{
Given a set of data specified as two vectors of `x` and `y` values, find an
elbow point.
}
\details{
This is a helper function for [get_starts()] to find elbow points.

Given a set of (x,y) data points, an "elbow point" can be defined by drawing
a line connecting the points for minimum and maximum x, and then finding the
x value of the observation where the distance to that line is greatest.

[get_starts()] uses elbow points as a way to automate separation of
concentration-time data into different kinetic phases in order to calculate
starting points for fitting TK model parameters. For example, if
concentration-time data are described by a two-compartment TK model, then
early and late elimination phases will be separated by an elbow point. This
helper function finds the elbow points. (When this function is called from
[get_starts()], `x` will be a vector of time values, and `y` will be a vector
of log-transformed dose-normalized concentration values.)
}
\author{
Caroline Ring
}
