% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_2comp.R
\name{cp_2comp}
\alias{cp_2comp}
\title{Analytical 2-compartment model}
\usage{
cp_2comp(params, time, dose, route, medium = "plasma")
}
\arguments{
\item{params}{A named numeric vector of parameter values. See Details for requirements.}

\item{time}{A numeric vector of times, reflecting the time points
when concentration is measured after the corresponding single bolus dose.
Must be same length as other arguments, or length 1.}

\item{dose}{A numeric vector of doses, reflecting single bolus doses
administered at time 0. Must be same length as other arguments, or
length 1.}

\item{route}{A character vector, reflecting the route of administration of
each single bolus dose: \code{'oral'} or \code{'iv'}.  Must be same length as \code{time}
and \code{dose}, or length 1.}

\item{medium}{A character vector reflecting the medium in which each resulting
concentration is to be calculated: "blood" or "plasma". Default is "plasma".
Must be same length as other arguments, or length 1.}
}
\value{
A vector of blood or plasma concentration values (mass chemical/volume media) corresponding to each
value in \code{time}
}
\description{
Calculates plasma concentration according to the analytical solution for the
2-compartment model.
}
\seealso{
Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other 2-compartment model functions: 
\code{\link{auc_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{get_params_2comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other model concentration functions: 
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{cp_flat}()}
}
\author{
Caroline Ring, John Wambaugh
}
\concept{2-compartment model functions}
\concept{built-in model functions}
\concept{model concentration functions}
