% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backward_linkages.R
\name{backward_linkages}
\alias{backward_linkages}
\title{Backward linkages}
\usage{
backward_linkages(Im)
}
\arguments{
\item{Im}{A Leontieff inverse matrix created by the
\code{\link{leontieff_inverse_create}} function.}
}
\value{
The vector of industry (product) backward linkages in a wide
data.frame class, following the column names of the Leontieff 
inverse matrix.
}
\description{
Backward linkages as defined by the Eurostat Manual of Supply, Use and
Input-Output Tables (see p506-507.)
}
\examples{
de_coeff <- input_coefficient_matrix_create( iotable_get(), 
                                             digits = 4 )
I <- leontieff_inverse_create (de_coeff)
backward_linkages (I)
}
\seealso{
Other interindustrial linkage functions: 
\code{\link{forward_linkages}()}
}
\concept{interindustrial linkage functions}
