% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_transpose.R
\name{vector_transpose_wider}
\alias{vector_transpose_wider}
\title{Transpose a vector to wider format}
\usage{
vector_transpose_wider(
  data_table,
  names_from,
  values_from,
  key_column_name = NULL,
  key_column_values = NULL
)
}
\arguments{
\item{data_table}{A matrix or vector that normally has a key column. If the key column must be created 
or replaced, used \code{key_column_name}  and \code{key_column_values}.}

\item{names_from, values_from}{A pair of
arguments describing which column (or columns) to get the name of the
output column (`names_from`), and which column (or columns) to get the
cell values from (`values_from`).}

\item{key_column_name}{The name of the key column.}

\item{key_column_values}{You can explicitly supply key column values. Defaults to \code{NULL} when the
key column values will be created from the long data.}
}
\description{
Many vectors (indicators, multipliers) are create in the wide form to conform matrixes in 
analytical functions.  For binding it is more useful to have them in wide format.
}
\details{
This is a wrapper around \code{\link[tidyr]{pivot_wider}} so you do not necessarily need to
import or load the entire \emph{tidyr} package.
}
\examples{
vector_transpose_wider (data_table =  germany_airpol[, -2],
                        names_from = 'induse',
                        values_from = 'value')
                        
vector_transpose_wider (data_table =  germany_airpol[1:8, 3:4],
                        names_from = 'induse',
                        values_from = 'value', 
                        key_column_values = "CO2_emission" )
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()}
}
\concept{iotables processing functions}
