% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tidy.ipd}
\alias{tidy.ipd}
\title{Tidy an IPD Fit}
\usage{
\method{tidy}{ipd}(x, ...)
}
\arguments{
\item{x}{An object of class \code{ipd}.}

\item{...}{Additional arguments to be passed to the tidy function.}
}
\value{
A tidy data frame of the model's coefficients.
}
\description{
Tidies the IPD method/model fit into a data frame.
}
\examples{

#-- Generate Example Data

set.seed(2023)

dat <- simdat(n = c(300, 300, 300), effect = 1, sigma_Y = 1)

head(dat)

formula <- Y - f ~ X1

#-- Fit IPD

fit <- ipd(formula, method = "postpi_analytic", model = "ols",

  data = dat, label = "set")

#-- Tidy Output

tidy(fit)

}
