% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdat.R
\name{simdat}
\alias{simdat}
\title{Data generation function for various underlying models}
\usage{
simdat(
  n = c(300, 300, 300),
  effect = 1,
  sigma_Y = 1,
  model = "ols",
  shift = 0,
  scale = 1
)
}
\arguments{
\item{n}{Integer vector of size 3 indicating the sample sizes in the
training, labeled, and unlabeled data sets, respectively}

\item{effect}{Regression coefficient for the first variable of interest for
inference. Defaults is 1.}

\item{sigma_Y}{Residual variance for the generated outcome. Defaults is 1.}

\item{model}{The type of model to be generated. Must be one of
\code{"mean"}, \code{"quantile"}, \code{"ols"}, or \code{"logistic"}.
Default is \code{"ols"}.}

\item{shift}{Scalar shift of the predictions for continuous outcomes
(i.e., "mean", "quantile", and "ols"). Defaults to 0.}

\item{scale}{Scaling factor for the predictions for continuous outcomes
(i.e., "mean", "quantile", and "ols"). Defaults to 1.}
}
\value{
A data.frame containing n rows and columns corresponding to
the labeled outcome (Y), the predicted outcome (f), a character variable
(set) indicating which data set the observation belongs to (training,
labeled, or unlabeled), and four independent, normally distributed
predictors (X1, X2, X3, and X4), where applicable.
}
\description{
Data generation function for various underlying models
}
\examples{

#-- Mean

dat_mean <- simdat(c(100, 100, 100), effect = 1, sigma_Y = 1,

  model = "mean")

head(dat_mean)

#-- Linear Regression

dat_ols <- simdat(c(100, 100, 100), effect = 1, sigma_Y = 1,

  model = "ols")

head(dat_ols)

}
