% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfCluster}
\alias{ipfCluster}
\title{Creates clusters using the specified method}
\usage{
ipfCluster(data, method = "k-means", k = NULL, grid = NULL, ...)
}
\arguments{
\item{data}{a data frame}

\item{method}{the method to use to clusterize the data. Implemented
methods are:
'k-means' for k-means algorithm. Requires parameter k.
'grid' for clustering based on grid partition. Requires parameter grid.
'AP' for affinity propagation algorithm.}

\item{k}{parameter k}

\item{grid}{a vector with the grid size for the 'grid' method}

\item{...}{additional parameters for apcluster and apclusterK}
}
\value{
A list with:
                 clusters -> a numeric vector with the ids of the clusters
                 centers  -> a data frame with the centers of the clusters
}
\description{
Creates clusters using the the specified method
and assigns a cluster id to each cluster
}
\examples{

    clusters <- ipfCluster(head(ipftrain, 20)[, 169:170], k = 4)

    clusters <- ipfCluster(head(ipftrain[, grep('^wap', names(ipftrain))], 20),
    method = 'AP')$clusters

}
