% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{iana_special_assignments}
\alias{iana_special_assignments}
\title{IANA IPv4 Special-Purpose Address Registry}
\format{
A data frame with 256 rows and 5 variables
}
\usage{
data(iana_special_assignments)
}
\description{
This dataset contains the registry of special address space assignments
for IPv4 IP addresses, as set by IANA. It consists of a data.frame containing the columns:
\itemize{
  \item \code{address_block}: the full IPv4 range (chr) (e.g. "11.0.0.0/8")
  \item \code{name}: the descriptive name for the special-purpose address block
  \item \code{rfc}: the Request for Comment (RfC) through which the special-purpose address block was requested
  \item \code{allocation_date}: the allocation date of the block, stored as YYYY-MM.
  \item \code{source}: whether an address from the allocated special-purpose address block is valid
  when used as the source address of an IP datagram that transits two devices (\code{TRUE}) or not (\code{FALSE}).
  \item \code{destination}: whether an address from the allocated special-purpose address block is valid when
  used as the destination address of an IP datagram that transits two devices (\code{TRUE}) or not (\code{FALSE}).
  \item \code{forwardable}: whether a router may forward an IP datagram whose destination address is drawn from the
  allocated special-purpose address block between external interfaces (\code{TRUE}) or not (\code{FALSE}).
  \item \code{global}: whether an IP datagram whose destination address is drawn from the allocated special-purpose
  address block is forwardable beyond a specified administrative domain (\code{TRUE}) or not (\code{FALSE}).
  \item \code{reserved_by_protocol}. whether the special-purpose address block is reserved by IP, itself.
  This value is \code{TRUE} if the RFC that created the special-purpose address block requires all compliant IP
  implementations to behave in a special way when processing packets either to or from addresses contained by
  the address block, and \code{FALSE} otherwise.
}
}
\note{
Last updated 2014-08-07
}
\references{
\itemize{
  \item The \href{https://www.iana.org/assignments/ipv4-address-space/ipv4-address-space.xhtml}{
  IANA page} on specially assigned blocks.
  \item \href{https://tools.ietf.org/html/rfc5376}{RFC5376}
  \item \href{https://tools.ietf.org/html/rfc6890}{RFC6890}
}
}
\seealso{
\code{\link{iana_special_assignments_refresh}} to refresh this dataset,
and \code{\link{iana_assignments}} for a dataset covering general (non-special) IPv4 assignments.
}
\keyword{datasets}
