% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/is.R
\name{is_multicast}
\alias{is_multicast}
\alias{is_ipv4}
\alias{is_ipv6}
\alias{is_valid}
\title{Logical checks for IP addresses}
\usage{
is_multicast(ip_addresses)

is_ipv4(ip_addresses)

is_ipv6(ip_addresses)

is_valid(ip_addresses)
}
\arguments{
\item{ip_addresses}{a vector of IP addresses}
}
\value{
a vector of TRUE or FALSE values, indicating whether an IP is multicast or not,
or NA values if the IP addresses are NAs.
}
\description{
Check whether an IP address is valid with \code{is_valid},
IPv4 with \code{is_ipv4}, IPv6 with \code{is_ipv6}, or multicast (intended to point to
multiple machines) with \code{is_multicast}
}
\examples{
# This is multicast
is_multicast("224.0.0.2")

# It's also IPv4
is_ipv4("224.0.0.2")

# It's not IPv6
is_ipv6("224.0.0.2")

}
\seealso{
\code{\link{ip_classify}} for character rather than logical classification.
}
